package decoratorexample;

public class LettoreMain {

    public static final void main(String args[]) {
        String fileName = "testo.txt";
        Copy copy = new Copy(new LineReader(fileName));
        // semplice stampa delle linee lette
        LineWriter lw = new StraightLineWriter(System.out);
        System.out.println("Stampa semplice:");
        copy.toOutput(lw);
        // stampa delle linee lette con un decorator che non aggiunge funzionalità
        System.out.println("\nStampa semplice con decorator:");
        copy.toOutput(new LineWriterDecorator(lw));
        // stampa delle linee lette con un decorator che aggiunge la funzionalità
        // di conteggio caratteri alla classe LineWriter
        System.out.println("\nStampa semplice con decorator che conta i caratteri:");
        copy.toOutput(new StatLineWriterDecorator(lw));
        // stampa delle linee lette con un decorator che aggiunge la funzionalità
        // di conteggio delle linee alla classe LineWriter
        System.out.println("\nStampa con decorator che conta le linee:");
        copy.toOutput(new LineCounterLineWriterDecorator(lw));
        // stampa delle linee lette con un decorator che aggiunge la funzionalità
        // di conteggio della lettera 's' alla classe LineWriter
        System.out.println("\nStampa con decorator che conta le occorrenze della lettera 's':");
        copy.toOutput(new LetterSCounterLineWriterDecorator(lw));
        // se voglio combinare il conteggio dei caratteri con il conteggio 
        // delle linee?
        System.out.println("\nStampa con decorator cont. linee + cont. chars:");
        copy.toOutput(new StatLineWriterDecorator(new LineCounterLineWriterDecorator(lw)));
        // E se invece voglio combinare il conteggio delle linee con il conteggio 
        // delle occorrenze della lettera 's'?
        System.out.println("\nStampa con decorator cont. linee + cont. occ. 's':");
        copy.toOutput(new LetterSCounterLineWriterDecorator(new LineCounterLineWriterDecorator(lw)));
        // E se invece voglio combinare il conteggio delle linee, con il conteggio 
        // dei caretteri e il conteggio delle lettere 's'?
        System.out.println("\nStampa con decorator cont. chars + cont. linee + cont. occ. 's':");
        copy.toOutput(new LetterSCounterLineWriterDecorator(new LineCounterLineWriterDecorator(new StatLineWriterDecorator(lw))));
        /**
         * Nel nostro caso con il Decorator pattern abbiamo implementato 3
         * classi che estendono le funzionalità di LineWriter e abbiamo in
         * totale 2^3 = 8 possibili combinazioni. Questo dimostra la flessibilità
         * di questo pattern, che permette di fare delle combinazioni a run-time
         * (a tempo di compilazione potrei non sapere che combinazioni vuole
         * fare l'utente). Inoltre, se avessimo voluto utilizzare
         * l'ereditarietà, avremmo dovuto implementare 8 classi diverse. Ora
         * immaginate di avere 10 funzionalità aggiuntive e volerle combinare,
         * data la vita media del programmatore, è molto difficile riuscire ad
         * implementare tutte le 2^10 classi con l'ereditarietà, mentre con
         * il pattern Decorator basta creare 10 classi, dove ogni classe
         * implementa una funzionalità aggiuntiva.
         */
    }

}
